VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form frmAIsyncDIO 
   Caption         =   "KPCI-3110, 1.0 MHz Sampling Rate from 4 channels"
   ClientHeight    =   4170
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6090
   LinkTopic       =   "Form1"
   ScaleHeight     =   4170
   ScaleWidth      =   6090
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Stop AI"
      Height          =   495
      Left            =   480
      TabIndex        =   6
      Top             =   960
      Width           =   1215
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4440
      TabIndex        =   5
      Top             =   3360
      Width           =   735
   End
   Begin VB.CommandButton cmdDI 
      Caption         =   "Read Polled DI Input"
      Height          =   495
      Left            =   480
      TabIndex        =   1
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CommandButton cmdAI 
      Caption         =   "Start AI"
      Height          =   495
      Left            =   480
      TabIndex        =   0
      Top             =   360
      Width           =   1215
   End
   Begin DlsrLib.DriverLINXSR SR_DI 
      Left            =   4800
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR1700 
      Left            =   4800
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label lblDataLost 
      BackColor       =   &H80000009&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Left            =   480
      TabIndex        =   7
      Top             =   3120
      Width           =   3615
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   480
      TabIndex        =   4
      Top             =   2640
      Width           =   3615
   End
   Begin VB.Label lblDI 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   2040
      TabIndex        =   3
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label lblAI 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   2040
      TabIndex        =   2
      Top             =   480
      Width           =   1215
   End
End
Attribute VB_Name = "frmAIsyncDIO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim DataArray() As Single
Dim bufSize As Long
Dim bufNum As Integer

Private Sub cmdAI_Click()
    SR1700.Req_op = DL_START
    SR1700.Refresh
    lblStatus.Caption = SR1700.Message
   End Sub

Private Sub cmdDI_Click()
    SR_DI.Refresh
    lblStatus.Caption = SR_DI.Message
    lblDI.Caption = SR_DI.Res_Sta_ioValue
    ' for polled mode operations, the SR control
    ' can contain the single value in the
    ' .Res_Sta_ioValue property
End Sub



Private Sub cmdExit_Click()

SR1700.Req_DLL_name = ""
SR_DI.Req_DLL_name = ""
End

End Sub

Private Sub Command1_Click()
SR1700.Req_op = DL_STOP
SR1700.Refresh
End Sub

Private Sub Form_Load()
bufSize = 300000
ReDim DataArray(0 To bufSize) As Single

bufNum = 10  ' how many buffers
Dim DrvName As String

'Open drivers for each SR object
' Use an SR object for each subsystem

' change path and name as required for specific boards in use
DrvName = "kpci3100"
SR1700.Req_DLL_name = DrvName
SR_DI.Req_DLL_name = DrvName

'Initialize each SR
SR_DI.Req_device = 0      ' change device number as necessary according_
SR_DI.Req_mode = DL_OTHER  ' to your DLinx Config Utility settings
SR_DI.Req_op = DL_INITIALIZE
SR_DI.Refresh

'Check for error
lblStatus.Caption = SR_DI.Message

'Initialize SR for AI task
SR1700.Req_device = 0
SR1700.Req_mode = DL_OTHER
SR1700.Req_op = DL_INITIALIZE
SR1700.Refresh

'Check for error
lblStatus.Caption = SR1700.Message


'  ********************************************
'Set up each service request
SR1700.Req_device = 0
SR1700.Req_subsystem = DL_AI
SR1700.Req_mode = DL_DMA

SR1700.Req_op = DL_START
SR1700.Evt_Str_type = DL_COMMAND  ' start when told

SR1700.Evt_Stp_type = DL_COMMAND  ' stop when told

SR1700.Evt_Tim_type = DL_RATEEVENT   ' rate of acquisition information
SR1700.Evt_Tim_rateChannel = DL_DEFAULTTIMER
SR1700.Evt_Tim_rateMode = DL_RATEGEN
SR1700.Evt_Tim_rateClock = DL_INTERNAL1
SR1700.Evt_Tim_rateGate = DL_DISABLED
SR1700.Evt_Tim_ratePeriod = SR1700.DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000000!)
           'for KPCI-3110 sampe at maximum for multichannel rate
           
' channel and buffer information
SR1700.Sel_chan_format = DL_tNATIVE
SR1700.Sel_chan_N = 2       ' a start stop range
SR1700.Sel_chan_start = 0   'Channel 0
SR1700.Sel_chan_stop = 3    'Channel 3
SR1700.Sel_chan_startGainCode = SR1700.DLGain2Code(-1) 'bipolar gain of 1
SR1700.Sel_chan_stopGainCode = SR1700.DLGain2Code(-1)  'bipolar gain of 1
SR1700.Sel_buf_N = bufNum
SR1700.Sel_buf_samples = bufSize  ' bufNum buffers of bufSize samples each
SR1700.Sel_buf_notify = DL_NOTIFY ' post buffer filled messages

        
'Setup Service Request
SR_DI.Req_subsystem = DL_DI
SR_DI.Req_mode = DL_POLLED
SR_DI.Req_op = DL_START
SR_DI.Evt_Str_type = DL_NULLEVENT
SR_DI.Evt_Stp_type = DL_NULLEVENT
SR_DI.Evt_Tim_type = DL_NULLEVENT
SR_DI.Sel_chan_format = DL_tNATIVE
SR_DI.Sel_chan_N = 1                ' single channel
SR_DI.Sel_chan_start = 0            'Channel 0
SR_DI.Sel_chan_startGainCode = 0
SR_DI.Sel_buf_N = 0                 ' polled mode so no buffer needed
SR_DI.Sel_buf_notify = DL_NOEVENTS  ' post no messages


End Sub

Public Sub ShowDriverLINXStatus(SR As DriverLINXSR)

    Dim DLResultCode As Integer
    Dim OriginalReq_op As Integer
    
    With SR
        ' DriverLINX returns result codes in the Res_result property.
        DLResultCode = .Res_result
        
        If DLResultCode <> DL_NoErr Then
            ' DriverLINX can display a message box that describes
            '   the status of a Service Request.
            
            ' First save the current Req_op property value
            OriginalReq_op = .Req_op
            
            ' Then change the value of the Req_op property to
            '   DL_MESSAGEBOX, and call the Refresh method.
            .Req_op = DL_MESSAGEBOX
            .Refresh
            
            ' Afterwards, restore Req_op to its original value
            .Req_op = OriginalReq_op
        End If
    End With

End Sub

Private Sub Form_Terminate()
SR1700.Req_DLL_name = ""

End Sub

Private Sub Form_Unload(Cancel As Integer)
SR1700.Req_DLL_name = ""

End Sub

Private Sub SR1700_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

Dim samples As Long
Static bufcount As Integer

'data is converted to volts and moved from memory buffer to local array, DataArray
samples = SR1700.VBArrayBufferConvert(bufIndex, 0, bufSize, DataArray(), DL_tSINGLE, 0#, 0#)
' use multiple local arrays to keep multiple buffers of data

lblAI.Caption = DataArray(0) ' display first value from the buffer

bufcount = bufcount + 1
lblStatus.Caption = Str(0.3 * bufcount) + " seconds so far"
' each buffer is 300000 samples.  Sample rate of 1MHz, so each buffer filled
' message represents 0.3 seconds of data

End Sub

Private Sub SR1700_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
' Data Lost occurs if there is a FIFO overrun or if the
' driver does not get new data within the expected interval
' based upon the sample speed, eg, the board has stopped for some reason.
' If Data Lost message is posted, acquisition from the board will have
' been already stopped.
' Place code here to respond to that condition

Static dataLost As Integer

dataLost = dataLost + 1
lblDataLost.Caption = "Acquisition is was halted " + Str(dataLost) + " times."
Beep
' restart the AI task
SR1700.Req_op = DL_START
SR1700.Refresh

End Sub
